import sys
from PyQt5.QtWidgets import (QWidget,
    QVBoxLayout, QHBoxLayout, QApplication, QPushButton, QLabel, QLineEdit)
from PyQt5 import*
import subprocess

class Example(QWidget):

    def __init__(self):
        super().__init__()

        self.initUI()


    def initUI(self):
        font=QtGui.QFont("00コミック7",16)

        # ラベル名の設定
        lbl1 = QLabel('周波数(MHz)　')
        lbl1.setFont(font)
        lbl2 = QLabel('開始時刻(XX:YY)')
        lbl2.setFont(font)
        lbl3 = QLabel('曜日(0:月,1:火,2:水,3:木,4:金,5:土,6:日)')
        lbl3.setFont(font)
        lbl4 = QLabel('録音時間(min)')
        lbl4.setFont(font)
        lbl5 = QLabel('Device Arguments.')
        lbl5.setFont(font)
        lbl6 = QLabel('予約する')
        lbl6.setFont(font)
        self.lbl7 = QLabel('予約する日時指定をしてください')
        self.lbl7.setFont(font)

        self.edit1=QLineEdit('85.1',self)
        self.edit1.setFont(font)
        self.edit2=QLineEdit('12:30',self)
        self.edit2.setFont(font)
        self.edit3=QLineEdit('6',self)
        self.edit3.setFont(font)
        self.edit4=QLineEdit('25',self)
        self.edit4.setFont(font)
        self.edit5=QLineEdit('rtl=0',self)
        self.edit5.setFont(font)

        btn6=QPushButton("予約する")
        btn6.setCheckable(True)
        btn6.setFont(font)
        btn6.setStyleSheet("background-color: #ffcf54")
        
        firstlayout=QVBoxLayout()
        firstlayout.addWidget(lbl1)
        firstlayout.addWidget(self.edit1)
#        firstlayout.addWidget(btn1)

        secondlayout=QVBoxLayout()
        secondlayout.addWidget(lbl2)
        secondlayout.addWidget(self.edit2)
#        secondlayout.addWidget(btn2)

        thirdlayout=QVBoxLayout()
        thirdlayout.addWidget(lbl3)
        thirdlayout.addWidget(self.edit3)
#        thirdlayout.addWidget(btn3)

        fourlayout=QVBoxLayout()
        fourlayout.addWidget(lbl4)
        fourlayout.addWidget(self.edit4)
#        fourlayout.addWidget(btn3)

        fivelayout=QVBoxLayout()
        fivelayout.addWidget(lbl5)
        fivelayout.addWidget(self.edit5)
#        fivelayout.addWidget(btn4)

        sixlayout=QVBoxLayout()
#        sixlayout.addWidget(lbl5)
#        sixlayout.addWidget(self.edit5)
        sixlayout.addWidget(btn6)

        sevenlayout=QVBoxLayout()
        sevenlayout.addWidget(self.lbl7)
#        sevenlayout.addWidget(self.edit5)
#        sevenlayout.addWidget(btn5)
        
        layout=QVBoxLayout()
        layout.addLayout(firstlayout)
        layout.addLayout(secondlayout)
        layout.addLayout(thirdlayout)
        layout.addLayout(fourlayout)
        layout.addLayout(fivelayout)
        layout.addLayout(sixlayout)
        layout.addLayout(sevenlayout)
        
        self.setLayout(layout)
        
        btn6.clicked[bool].connect(self.buttonClicked)  
        
        self.setWindowTitle('JFM Recorder Lancher 0.2 (C)falcon')
        self.setGeometry(200, 100, 300, 400)
           
    
    def buttonClicked(self,pressed):

#        if pressed:
            self.lbl7.setText('録音予約中')
            opt1 = str(self.edit1.text())
            opt2 = str(self.edit2.text())
            opt3 = str(self.edit3.text())
            opt4 = str(self.edit4.text())
            opt5 = str(self.edit5.text())
            print(opt1,opt2,opt3,opt4,opt5)
#            cmd = 'jfmradio_recorder_01 {} {} {} {} {}'.format(opt1,opt2,opt3,opt4,opt5)
            cmd = 'python jfmradio_recorder_01.py {} {} {} {} {}'.format(opt1,opt2,opt3,opt4,opt5)
#            print(cmd)
            subprocess.Popen(cmd,shell=True).wait()
            self.close()
#        else :
#            self.lbl7.setText('予約する日時指定をしてください')
#            subprocess.Popen(cmd,shell=True).terminate()


if __name__ == '__main__':

    app = QApplication(sys.argv)
    main_window = Example()
    main_window.show()
    sys.exit(app.exec_())