##################################################
#Project Name    : jfm_recorder (FM)
#File Name       : jfm_rec(version No.) version 0.5
#Encoding        : python3.9(inclueding GRC3.8)
#Creation Date   : 2022.1.15
#Release note
#2022.3.12 : 放送局をラジオボタン化、画面デザイン変更、番組表入手
#2022.3.26 : ステレオ受信に対応
#
#Copyright c 2021-2022 falconblog.org. All rights reserved.
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <https://www.gnu.org/licenses/>.
##################################################
import sys
from PyQt5.QtWidgets import (QWidget,
    QVBoxLayout, QHBoxLayout, QApplication, QPushButton, QLabel, QLineEdit, QComboBox, QTextEdit,QSizePolicy)
from PyQt5 import*
import subprocess
import configparser
import radiko_v3_fm
import datetime,time

# 初期設定値ファイルセット
inifile = configparser.ConfigParser()
inifile.read('settings_fm.ini',encoding='utf-8_sig')

class Example(QWidget):

    def __init__(self):
        super().__init__()

        self.initUI()

    def initUI(self):
        font=QtGui.QFont("00コミック7",16)
        font2=QtGui.QFont("00コミック7",10)
        
# ラベル名の設定
        global lbl7
        lbl1 = QLabel('放送局選択')
        lbl1.setFont(font)        
        lbl2 = QLabel('開始時刻')
        lbl2.setFont(font)
        lbl3 = QLabel('録音回数')
        lbl3.setFont(font)
        lbl4 = QLabel('録音時間(分)')
        lbl4.setFont(font)
        lbl5 = QLabel('チューナー')
        lbl5.setFont(font)
        lbl6 = QLabel('予約する')
        lbl6.setFont(font)
        lbl7 = QTextEdit('放送局を選択すると、現在の番組表を表示します')
        lbl7.setFont(font2)
        lbl8 = QLabel('曜日')
        lbl8.setFont(font)
        lbl9 = QLabel('受信方式')
        lbl9.setFont(font)

# 受信周波数設定
#        self.edit1=QLineEdit('828',self)
#        self.edit1=QLineEdit(inifile.get('SECTION1', 'data1'),self)
#        self.edit1.setFont(font)

# 開始時間設定    
        self.edit2=QLineEdit(inifile.get('SECTION1', 'data2'),self)
        self.edit2.setFont(font)
#        self.edit3=QLineEdit('6',self)
#        self.edit3.setFont(font)

# 録音回数設定
        global lbl31
        lbl31 = '1'
#        self.lbl31 = QLabel('5',self)
        self.combo3 = QComboBox(self)
#        self.combo3.addItem('0')
        self.combo3.addItem('1')
        self.combo3.addItem('2')
        self.combo3.addItem('3')
        self.combo3.addItem('4')
        self.combo3.addItem('5')
        self.combo3.addItem('6')
        self.combo3.addItem('8')
        self.combo3.addItem('10')
        self.combo3.addItem('25')
        self.combo3.setCurrentIndex(0)
        self.combo3.setFont(font)

# 録音時間設定              
        self.edit4=QLineEdit(inifile.get('SECTION1', 'data3'),self)
        self.edit4.setFont(font)

# USBチューナー設定
        global lbl51
        lbl51 = 'rtl=0'
#        self.edit5=QLineEdit('rtl=0,direct_samp=2',self)
#        self.edit5.setFont(font)
#        self.lbl51 = QLabel('rtl=0,direct_samp=2',self)
        self.combo5 = QComboBox(self)
        self.combo5.addItem('rtl=0')
        self.combo5.addItem('hackrf=0')
        self.combo5.addItem('rtl=1')
        self.combo5.addItem('rtl=2')
        self.combo5.setFont(font)

# モノラルステレオ設定
        global lbl91
        lbl91 = 'Mono'
        self.combo9 = QComboBox(self)
        self.combo9.addItem('Mono')
        self.combo9.addItem('Stereo')
        self.combo9.setFont(font)

# 放送局ラジオボタングループ
        self.radioGroup = QtWidgets.QButtonGroup()

# 放送局ラジオボタン選択
        btn11=QtWidgets.QRadioButton(inifile.get('CH1', 'channel'),self)
        btn11.setChecked(True)
        btn11.setFont(font)
        btn11.setStyleSheet(inifile.get('CH1', 'back_color'))

        btn12=QtWidgets.QRadioButton(inifile.get('CH2', 'channel'),self)
        btn12.setChecked(False)
        btn12.setFont(font)
        btn12.setStyleSheet(inifile.get('CH2', 'back_color'))

        btn13=QtWidgets.QRadioButton(inifile.get('CH3', 'channel'),self)
        btn13.setChecked(False)
        btn13.setFont(font)
        btn13.setStyleSheet(inifile.get('CH3', 'back_color'))

        btn14=QtWidgets.QRadioButton(inifile.get('CH4', 'channel'),self)
        btn14.setChecked(False)
        btn14.setFont(font)
        btn14.setStyleSheet(inifile.get('CH4', 'back_color'))

        btn15=QtWidgets.QRadioButton(inifile.get('CH5', 'channel'),self)
        btn15.setChecked(False)
        btn15.setFont(font)
        btn15.setStyleSheet(inifile.get('CH5', 'back_color'))

        btn16=QtWidgets.QRadioButton(inifile.get('CH6', 'channel'),self)
        btn16.setChecked(True)
        btn16.setFont(font)
        btn16.setStyleSheet(inifile.get('CH6', 'back_color'))

        btn17=QtWidgets.QRadioButton(inifile.get('CH7', 'channel'),self)
        btn17.setChecked(False)
        btn17.setFont(font)
        btn17.setStyleSheet(inifile.get('CH7', 'back_color'))

        btn18=QtWidgets.QRadioButton(inifile.get('CH8', 'channel'),self)
        btn18.setChecked(False)
        btn18.setFont(font)
        btn18.setStyleSheet(inifile.get('CH8', 'back_color'))

        btn19=QtWidgets.QRadioButton(inifile.get('CH9', 'channel'),self)
        btn19.setChecked(False)
        btn19.setFont(font)
        btn19.setStyleSheet(inifile.get('CH9', 'back_color'))

        btn20=QtWidgets.QRadioButton(inifile.get('CH10', 'channel'),self)
        btn20.setChecked(False)
        btn20.setFont(font)
        btn20.setStyleSheet(inifile.get('CH10', 'back_color'))

# 放送局ラジオボタンオブジェクトのグループ登録
        self.radioGroup.addButton(btn11, 1)
        self.radioGroup.addButton(btn12, 2)
        self.radioGroup.addButton(btn13, 3)
        self.radioGroup.addButton(btn14, 4)
        self.radioGroup.addButton(btn15, 5)
        self.radioGroup.addButton(btn16, 6)
        self.radioGroup.addButton(btn17, 7)
        self.radioGroup.addButton(btn18, 8)
        self.radioGroup.addButton(btn19, 9)
        self.radioGroup.addButton(btn20, 10)
# 放送局ラジオボタン初期値設定
        global lbl21,lbl61
        btn11.setChecked(True)
        lbl21 = str(inifile.get('CH1', 'freq'))
#        lbl41 = str(inifile.get('CH1', 'dulation'))
        lbl61 = str(inifile.get('CH1', 'file_name'))
#        lbl71 = str(inifile.get('CH1', 'week_table'))

# 曜日設定
# 曜日ラジオボタングループ
        self.radioGroup_y = QtWidgets.QButtonGroup()

# 曜日ラジオボタン選択
        btn30=QtWidgets.QRadioButton('月',self)
        btn30.setChecked(False)
        btn30.setFont(font2)
        btn31=QtWidgets.QRadioButton('火',self)
        btn31.setChecked(False)
        btn31.setFont(font2)
        btn32=QtWidgets.QRadioButton('水',self)
        btn32.setChecked(False)
        btn32.setFont(font2)
        btn33=QtWidgets.QRadioButton('木',self)
        btn33.setChecked(False)
        btn33.setFont(font2)
        btn34=QtWidgets.QRadioButton('金',self)
        btn34.setChecked(False)
        btn34.setFont(font2)
        btn35=QtWidgets.QRadioButton('土',self)
        btn35.setChecked(False)
        btn35.setFont(font2)
        btn35.setStyleSheet("color: blue;")
        btn36=QtWidgets.QRadioButton('日',self)
        btn36.setChecked(False)
        btn36.setFont(font2)
        btn36.setStyleSheet("color: red;")
        btn37=QtWidgets.QRadioButton('平日',self)
        btn37.setChecked(False)
        btn37.setFont(font2)
        
# 曜日ラジオボタンオブジェクトのグループ登録
        self.radioGroup_y.addButton(btn30, 0)
        self.radioGroup_y.addButton(btn31, 1)
        self.radioGroup_y.addButton(btn32, 2)
        self.radioGroup_y.addButton(btn33, 3)
        self.radioGroup_y.addButton(btn34, 4)
        self.radioGroup_y.addButton(btn35, 5)
        self.radioGroup_y.addButton(btn36, 6)
        self.radioGroup_y.addButton(btn37, 7)
        
# 曜日ラジオボタン変数初期値設定
        global lbl81
        btn36.setChecked(True)
        lbl81 = str('6')

# 放送受信ボタン設定1
        btn4=QPushButton("FM放送を聴く")
        btn4.setCheckable(False)
        btn4.setFont(font)
        btn4.setStyleSheet("background-color: #ffcf54")
# 放送予約ボタン設定1        
        btn6=QPushButton("FM放送を予約")
        btn6.setCheckable(True)
        btn6.setFont(font)
#        btn6.setStyleSheet("background-color: #ffcf54")
        btn6.setStyleSheet("background-color: #ff6d86")

# レイアウト設定        
#        firstlayout=QHBoxLayout()
#        firstlayout.addWidget(lbl1)
#        firstlayout.addWidget(lbl1a)
#        firstlayout.addWidget(self.edit1)

#        firstlayout_a=QHBoxLayout()
#        firstlayout_a.addWidget(lbl1)
#       firstlayout_a.addWidget(lbl1a)
#        firstlayout_a.addWidget(self.edit1)
#        firstlayout_a.addWidget(self.edit1a)

# 放送局ラジオボタン配置
        secondlayout=QVBoxLayout()
        secondlayout.addWidget(lbl1)
        secondlayout.addWidget(btn11)
        secondlayout.addWidget(btn12)
        secondlayout.addWidget(btn13)
        secondlayout.addWidget(btn14)
        secondlayout.addWidget(btn15)
        secondlayout.addWidget(btn16)
        secondlayout.addWidget(btn17)
        secondlayout.addWidget(btn18)
        secondlayout.addWidget(btn19)
        secondlayout.addWidget(btn20)

# 録音開始時刻、録音時間設定 lbl2,edit2, lbl4,edit4
        fourlayout=QHBoxLayout()
        fourlayout.addWidget(lbl2)
        fourlayout.addWidget(lbl4)
#        fourlayout.addWidget(lbl3)
        fourlayout_a=QHBoxLayout()
        fourlayout_a.addWidget(self.edit2)
        fourlayout_a.addWidget(self.edit4)
#        fourlayout_a.addWidget(self.combo3)

# 曜日ラジオボタン配置
        eightlayout=QVBoxLayout()
        eightlayout.addWidget(lbl8)
        eightlayout=QHBoxLayout()
        eightlayout.addWidget(btn30)
        eightlayout.addWidget(btn31)        
        eightlayout.addWidget(btn32)
        eightlayout.addWidget(btn33)        
        eightlayout.addWidget(btn34)
        eightlayout.addWidget(btn35)        
        eightlayout.addWidget(btn36)
        eightlayout.addWidget(btn37)

# 録音回数設定,USBチューナー設定 lbl3,combo3,lbl5,combo5
        thirdlayout=QHBoxLayout()
        thirdlayout.addWidget(lbl3)
        thirdlayout.addWidget(lbl5)
        thirdlayout.addWidget(lbl9)
        fivelayout=QHBoxLayout()
        fivelayout.addWidget(self.combo3)
        fivelayout.addWidget(self.combo5)
        fivelayout.addWidget(self.combo9)
        
# FM受信ボタン
        sixlayout_a=QHBoxLayout()
        sixlayout_a.addWidget(btn4)

# FM予約ボタン btn6
        sixlayout_b=QHBoxLayout()
        sixlayout_b.addWidget(btn6)

# 下部ガイダンス表示 lbl7
        sevenlayout=QVBoxLayout()
        sevenlayout.addWidget(lbl7)
        lbl7.setSizePolicy(QSizePolicy.Minimum, QSizePolicy.Expanding)

# レイアウト構築        
        layout=QVBoxLayout()
#        layout.addLayout(firstlayout)
#        layout.addLayout(firstlayout_a)
        layout.addLayout(secondlayout)
        layout.addLayout(eightlayout)
        layout.addLayout(fourlayout)
        layout.addLayout(fourlayout_a)
        layout.addLayout(thirdlayout)
        layout.addLayout(fivelayout)

        layout.addLayout(sixlayout_a)
#        layout.addLayout(sixlayout_b)
        layout.addLayout(sevenlayout)
        layout.addLayout(sixlayout_b)
        
        self.setLayout(layout)

# ボタンクリック挙動設定
        btn11.clicked[bool].connect(self.buttonClicked_1)
        btn12.clicked[bool].connect(self.buttonClicked_2)
        btn13.clicked[bool].connect(self.buttonClicked_3)
        btn14.clicked[bool].connect(self.buttonClicked_4)
        btn15.clicked[bool].connect(self.buttonClicked_5)
        btn16.clicked[bool].connect(self.buttonClicked_6)
        btn17.clicked[bool].connect(self.buttonClicked_7)
        btn18.clicked[bool].connect(self.buttonClicked_8)
        btn19.clicked[bool].connect(self.buttonClicked_9)
        btn20.clicked[bool].connect(self.buttonClicked_10)
        
        btn30.clicked[bool].connect(self.buttonClicked_30)
        btn31.clicked[bool].connect(self.buttonClicked_31)
        btn32.clicked[bool].connect(self.buttonClicked_32)
        btn33.clicked[bool].connect(self.buttonClicked_33)
        btn34.clicked[bool].connect(self.buttonClicked_34)
        btn35.clicked[bool].connect(self.buttonClicked_35)
        btn36.clicked[bool].connect(self.buttonClicked_36)
        btn37.clicked[bool].connect(self.buttonClicked_37)
#
        btn4.clicked[bool].connect(self.buttonClicked_ra)
        btn6.clicked[bool].connect(self.buttonClicked_ya)  
#        btn6.toggled[bool].connect(self.buttonClicked_ya)
        self.combo3.activated[str].connect(self.onActivated3)
        self.combo5.activated[str].connect(self.onActivated5)
        self.combo9.activated[str].connect(self.onActivated9)
        
# タイトル、ウィンドウ位置設定        
        self.setWindowTitle('JFM Recorder v.0.6a (C)falcon')
        self.setGeometry(100, 50, 400, 800)

# 番組変数設定
    def buttonClicked_1(self,pressed):
        global lbl21,lbl61
        lbl21 = str(inifile.get('CH1', 'freq'))
        lbl61 = str(inifile.get('CH1', 'file_name'))
        lbl7.clear()
        lbl7.append(radiko_v3_fm.radiko_v3(inifile.get('CH1', 'channel_id')))
    def buttonClicked_2(self,pressed):
        global lbl21,lbl61
        lbl21 = str(inifile.get('CH2', 'freq'))
        lbl61 = str(inifile.get('CH2', 'file_name'))
        lbl7.clear()
        lbl7.append(radiko_v3_fm.radiko_v3(inifile.get('CH2', 'channel_id')))
    def buttonClicked_3(self,pressed):
        global lbl21,lbl61
        lbl21 = str(inifile.get('CH3', 'freq'))
        lbl61 = str(inifile.get('CH3', 'file_name'))
        lbl7.clear()
        lbl7.append(radiko_v3_fm.radiko_v3(inifile.get('CH3', 'channel_id')))
    def buttonClicked_4(self,pressed):
        global lbl21,lbl61
        lbl21 = str(inifile.get('CH4', 'freq'))
        lbl61 = str(inifile.get('CH4', 'file_name'))
        lbl7.clear()
        lbl7.append(radiko_v3_fm.radiko_v3(inifile.get('CH4', 'channel_id')))
    def buttonClicked_5(self,pressed):
        global lbl21,lbl61
        lbl21 = str(inifile.get('CH5', 'freq'))
        lbl61 = str(inifile.get('CH5', 'file_name'))
        lbl7.clear()
        lbl7.append(radiko_v3_fm.radiko_v3(inifile.get('CH5', 'channel_id')))
    def buttonClicked_6(self,pressed):
        global lbl21,lbl61
        lbl21 = str(inifile.get('CH6', 'freq'))
        lbl61 = str(inifile.get('CH6', 'file_name'))
        lbl7.clear()
        lbl7.append(radiko_v3_fm.radiko_v3(inifile.get('CH6', 'channel_id')))
    def buttonClicked_7(self,pressed):
        global lbl21,lbl61
        lbl21 = str(inifile.get('CH7', 'freq'))
        lbl61 = str(inifile.get('CH7', 'file_name'))
        lbl7.clear()
        lbl7.append(radiko_v3_fm.radiko_v3(inifile.get('CH7', 'channel_id')))
    def buttonClicked_8(self,pressed):
        global lbl21,lbl61
        lbl21 = str(inifile.get('CH8', 'freq'))
        lbl61 = str(inifile.get('CH8', 'file_name'))
        lbl7.clear()
        lbl7.append(radiko_v3_fm.radiko_v3(inifile.get('CH8', 'channel_id')))
    def buttonClicked_9(self,pressed):
        global lbl21,lbl61
        lbl21 = str(inifile.get('CH9', 'freq'))
        lbl61 = str(inifile.get('CH9', 'file_name'))
        lbl7.clear()
        lbl7.append(radiko_v3_fm.radiko_v3(inifile.get('CH9', 'channel_id')))
    def buttonClicked_10(self,pressed):
        global lbl21,lbl61
        lbl21 = str(inifile.get('CH10', 'freq'))
        lbl61 = str(inifile.get('CH10', 'file_name'))
        lbl7.clear()
        lbl7.append(radiko_v3_fm.radiko_v3(inifile.get('CH10', 'channel_id')))
#        print(lbl21)
#        print(lbl41)
#        print(lbl61)
#        print(lbl71)
    def buttonClicked_30(self,pressed):
        global lbl81
        lbl81 = str('0')
    def buttonClicked_31(self,pressed):
        global lbl81
        lbl81 = str('1')
    def buttonClicked_32(self,pressed):
        global lbl81
        lbl81 = str('2')
    def buttonClicked_33(self,pressed):
        global lbl81
        lbl81 = str('3')
    def buttonClicked_34(self,pressed):
        global lbl81
        lbl81 = str('4')
    def buttonClicked_35(self,pressed):
        global lbl81
        lbl81 = str('5')
    def buttonClicked_36(self,pressed):
        global lbl81
        lbl81 = str('6')
    def buttonClicked_37(self,pressed):
        global lbl81
        lbl81 = str('7')

        
#録音回数プルダウン設定
    def onActivated3(self, text):
        global lbl31
#        self.lbl31.setText(text)
#        self.lbl31.adjustSize()
        lbl31 = str(text)
#        print(lbl31)

#USBチューナープルダウン設定
    def onActivated5(self, text):
        global lbl51
#        self.lbl51.setText(text)
#        self.lbl51.adjustSize()
        lbl51 = str(text)
#        print(lbl51)

#モノラルステレオ設定
    def onActivated9(self, text):
        global lbl91
        lbl91 = str(text)
#        print(lbl61)

# FM予約録音サブプロセス起動
# $ fmradio_recorder.exe <FREQ> <XX:YY> <week:No.> <Dulation:min> <times> <device arg.> <file_name> 
# lbl21=freq, edit2=録音開始時刻,lbl81=Week No. lbl51=録音時間, lbl1=録音回数, lbl71=device arg. lbl81=file_name  
    def buttonClicked_ya(self,pressed):
        if pressed:
            opt1 = str(lbl21) #周波数
            opt2 = str(self.edit2.text()) #録音開始時間
            opt3 = str(lbl81) #week No.
            opt4 = str(self.edit4.text()) #dulation
            opt5 = str(lbl31) #times
            opt6 = str(lbl51) #device arg.
            opt7 = str(lbl61) #file_name
            opt8 = str(lbl91) #受信方式
            print(opt1,opt2,opt3,opt4,opt5,opt6,opt7,opt8)
            cmd = 'jfmradio_recorder_06a.exe {} {} {} {} {} {} {} {}'.format(opt1,opt2,opt3,opt4,opt5,opt6,opt7,opt8)
            print(cmd)
            subprocess.Popen(cmd,shell=True).wait()
#            self.p= subprocess.Popen(cmd,shell=True)
            self.close()
#            self.p = subprocess.Popen(cmd)
#            time.sleep(5)
#        else:
#            os.kill(self.p.pid, signal.CTRL_C_EVENT)
#            print('q\n')
#            cmd2 = 'q\n'
#            subprocess.Popen(cmd2,shell=True)
#            subprocess.call(['taskkill', '/F', '/T', '/PID',  str(self._active_process.pid)])
#            self.close()
#            pass

# AM試聴サブプロセス起動
    def buttonClicked_ra(self,pressed):
#        if pressed:
#            self.lbl7.setText('ラジオ視聴中')
            opt1 = str(lbl21)
#            opt2 = str(self.edit2.text())
#            opt3 = str(self.edit3.text())
#            opt4 = str(self.edit4.text())
            opt5 = str(lbl51)
            opt8 = str(lbl91) #受信方式
#            print(opt1,opt2,opt3,opt4,opt5)
            cmd = 'fmradio_tuner_02.exe　{} {} {}'.format(opt1, opt5, opt8)
#            print(cmd)
            subprocess.Popen(cmd,shell=True).wait()
#            self.close()

if __name__ == '__main__':

    app = QApplication(sys.argv)
    main_window = Example()
    main_window.show()
    sys.exit(app.exec_())