##################################################
#Project Name    : jfmradio_recorder
#File Name       : jfmradio_recorder_(ver_No.)
#Encoding        : python2.7(inclueding GRC3.7)
#Creation Date   : 2022.1.13
#Last update     : 2022.4.10
#
#Copyright c 2021 falconblog.org. All rights reserved.
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <https://www.gnu.org/licenses/>.
##################################################
#!/usr/bin/env python2
# -*- coding: utf-8 -*-
##################################################
# GNU Radio Python Flow Graph
# Title: Top Block
# GNU Radio version: 3.7.13.5
##################################################

from gnuradio import analog
from gnuradio import blocks
from gnuradio import eng_notation
from gnuradio import filter
from gnuradio import gr
from gnuradio.eng_option import eng_option
from gnuradio.filter import firdes
from optparse import OptionParser
import osmosdr
import datetime,time
import schedule
import sys
from threading import Thread


import configparser
# 初期設定値ファイルセット
inifile = configparser.ConfigParser()
inifile.read('settings_fm.ini',encoding='utf-8-sig')
print('FM Radio Recorder Ver.0.6a Copyright 2022 falconblog.org. All rights reserved.')

class fmradio_mono_recoder(gr.top_block):

    def __init__(self):
        gr.top_block.__init__(self, "Top Block")

        ##################################################
        # Variables
        ##################################################
        self.volume = volume = 50
        self.tune_freq = tune_freq = TUNE_FREQ
        self.samp_rate = samp_rate = 1536000
        self.rf_gain = rf_gain = 30

	#############################
        now = datetime.datetime.now()
	#############################

        ##################################################
        # Blocks
        ##################################################
        self.osmosdr_source_0 = osmosdr.source( args="numchan=" + str(1) + " " + str(DEV_ARG) )
        self.osmosdr_source_0.set_sample_rate(samp_rate)
        self.osmosdr_source_0.set_center_freq(tune_freq*1e6, 0)
        self.osmosdr_source_0.set_freq_corr(0, 0)
        self.osmosdr_source_0.set_dc_offset_mode(0, 0)
        self.osmosdr_source_0.set_iq_balance_mode(0, 0)
        self.osmosdr_source_0.set_gain_mode(False, 0)
        self.osmosdr_source_0.set_gain(rf_gain, 0)
        self.osmosdr_source_0.set_if_gain(20, 0)
        self.osmosdr_source_0.set_bb_gain(20, 0)
        self.osmosdr_source_0.set_antenna('', 0)
        self.osmosdr_source_0.set_bandwidth(500*1e3, 0)

        self.low_pass_filter_0 = filter.fir_filter_ccf(4, firdes.low_pass(
        	1, samp_rate, 96000, 96000, firdes.WIN_BLACKMAN, 6.76))
        self.blocks_wavfile_sink_0 = blocks.wavfile_sink(PATH + FILE_NAME + now.strftime('_%Y%m%d_%H%M') +'.wav', 1, 48000, 16)
        self.blocks_multiply_const_vxx_0 = blocks.multiply_const_vff((volume*0.01, ))
        self.analog_fm_demod_cf_0 = analog.fm_demod_cf(
        	channel_rate=samp_rate/4,
        	audio_decim=8,
        	deviation=75000,
        	audio_pass=16000,
        	audio_stop=18500,
        	gain=1,
        	tau=50e-6,
        )



        ##################################################
        # Connections
        ##################################################
        self.connect((self.analog_fm_demod_cf_0, 0), (self.blocks_multiply_const_vxx_0, 0))
        self.connect((self.blocks_multiply_const_vxx_0, 0), (self.blocks_wavfile_sink_0, 0))
        self.connect((self.low_pass_filter_0, 0), (self.analog_fm_demod_cf_0, 0))
        self.connect((self.osmosdr_source_0, 0), (self.low_pass_filter_0, 0))

    def get_volume(self):
        return self.volume

    def set_volume(self, volume):
        self.volume = volume
        self.blocks_multiply_const_vxx_0.set_k((self.volume*0.01, ))

    def get_tune_freq(self):
        return self.tune_freq

    def set_tune_freq(self, tune_freq):
        self.tune_freq = tune_freq
        self.osmosdr_source_0.set_center_freq(self.tune_freq*1e6, 0)

    def get_samp_rate(self):
        return self.samp_rate

    def set_samp_rate(self, samp_rate):
        self.samp_rate = samp_rate
        self.osmosdr_source_0.set_sample_rate(self.samp_rate)
        self.low_pass_filter_0.set_taps(firdes.low_pass(1, self.samp_rate, 96000, 96000, firdes.WIN_BLACKMAN, 6.76))

    def get_rf_gain(self):
        return self.rf_gain

    def set_rf_gain(self, rf_gain):
        self.rf_gain = rf_gain
        self.osmosdr_source_0.set_gain(self.rf_gain, 0)

class fmradio_stereo_recoder(gr.top_block):

    def __init__(self):
        gr.top_block.__init__(self, "FMradio Stereo Recorder")

        ##################################################
        # Variables
        ##################################################
        self.resamp_rate = resamp_rate = 96e3
        self.volume = volume = 50
        self.tune_freq = tune_freq = TUNE_FREQ
        self.samp_rate = samp_rate = 1024e3
        self.rf_gain = rf_gain = 20
        self.pll_min_freq = pll_min_freq = 18950*2*3.14159/resamp_rate
        self.pll_max_freq = pll_max_freq = 19050*2*3.14159/resamp_rate
        self.audio_stop = audio_stop = 95e3
        self.audio_pass = audio_pass = 92e3
        self.Stereo_gain = Stereo_gain = 1

	#############################
        now = datetime.datetime.now()
	#############################

        ##################################################
        # Blocks
        ##################################################
        self.rtlsdr_source_0 = osmosdr.source( args="numchan=" + str(1) + " " + str(DEV_ARG))
        self.rtlsdr_source_0.set_time_unknown_pps(osmosdr.time_spec_t())
        self.rtlsdr_source_0.set_sample_rate(samp_rate)
        self.rtlsdr_source_0.set_center_freq(tune_freq*1e6, 0)
        self.rtlsdr_source_0.set_freq_corr(0, 0)
        self.rtlsdr_source_0.set_dc_offset_mode(0, 0)
        self.rtlsdr_source_0.set_iq_balance_mode(0, 0)
        self.rtlsdr_source_0.set_gain_mode(True, 0)
        self.rtlsdr_source_0.set_gain(rf_gain, 0)
        self.rtlsdr_source_0.set_if_gain(20, 0)
        self.rtlsdr_source_0.set_bb_gain(20, 0)
        self.rtlsdr_source_0.set_antenna('', 0)
        self.rtlsdr_source_0.set_bandwidth(0, 0)
        self.rational_resampler_xxx_0_0_0 = filter.rational_resampler_fff(
                interpolation=1,
                decimation=2,
                taps=None,
                fractional_bw=None)
        self.rational_resampler_xxx_0_0 = filter.rational_resampler_fff(
                interpolation=1,
                decimation=2,
                taps=None,
                fractional_bw=None)
        self.rational_resampler_xxx_0 = filter.rational_resampler_fff(
                interpolation=3,
                decimation=32,
                taps=None,
                fractional_bw=None)
        self.low_pass_filter_0_0_0_0 = filter.fir_filter_fff(
            1,
            firdes.low_pass(
                1,
                resamp_rate,
                15e3,
                2.0e3,
                firdes.WIN_HAMMING,
                6.76))
        self.low_pass_filter_0_0_0 = filter.fir_filter_fff(
            1,
            firdes.low_pass(
                Stereo_gain,
                resamp_rate,
                15e3,
                2.0e3,
                firdes.WIN_HAMMING,
                6.76))
        self.low_pass_filter_0_0 = filter.fir_filter_ccf(
            1,
            firdes.low_pass(
                1,
                samp_rate,
                80e3,
                10e3,
                firdes.WIN_HAMMING,
                6.76))
        self.blocks_wavfile_sink_0 = blocks.wavfile_sink(PATH + FILE_NAME + now.strftime('_%Y%m%d_%H%M_st') +'.wav', 2, 48000, 16)
        self.blocks_sub_xx_0 = blocks.sub_ff(1)
        self.blocks_multiply_xx_1 = blocks.multiply_vff(1)
        self.blocks_multiply_xx_0 = blocks.multiply_vcc(1)
        self.blocks_multiply_const_vxx_0_0_0 = blocks.multiply_const_ff(volume*0.01)
        self.blocks_multiply_const_vxx_0_0 = blocks.multiply_const_ff(volume*0.01)
        self.blocks_float_to_complex_0 = blocks.float_to_complex(1)
        self.blocks_delay_0 = blocks.delay(gr.sizeof_float*1, 3)
        self.blocks_complex_to_real_0 = blocks.complex_to_real(1)
        self.blocks_add_xx_0 = blocks.add_vff(1)
        self.band_pass_filter_0_0 = filter.fir_filter_ccf(
            1,
            firdes.band_pass(
                2,
                resamp_rate,
                35e3,
                41e3,
                1e3,
                firdes.WIN_HAMMING,
                6.76))
        self.band_pass_filter_0 = filter.fir_filter_ccf(
            1,
            firdes.band_pass(
                1,
                resamp_rate,
                17e3,
                21e3,
                1e3,
                firdes.WIN_HAMMING,
                6.76))
#        self.audio_sink_1 = audio.sink(48000, '', True)
        self.analog_pll_refout_cc_0 = analog.pll_refout_cc(200e-6, pll_max_freq, pll_min_freq)
        self.analog_fm_demod_cf_0_0 = analog.fm_demod_cf(
        	channel_rate=samp_rate,
        	audio_decim=1,
        	deviation=75000,
        	audio_pass=audio_pass,
        	audio_stop=audio_stop,
        	gain=1,
        	tau=0,
        )
        self.analog_fm_deemph_0_0 = analog.fm_deemph(fs=resamp_rate/2, tau=50e-6)
        self.analog_fm_deemph_0 = analog.fm_deemph(fs=resamp_rate/2, tau=50e-6)



        ##################################################
        # Connections
        ##################################################
        self.connect((self.analog_fm_deemph_0, 0), (self.blocks_multiply_const_vxx_0_0, 0))
        self.connect((self.analog_fm_deemph_0_0, 0), (self.blocks_multiply_const_vxx_0_0_0, 0))
        self.connect((self.analog_fm_demod_cf_0_0, 0), (self.rational_resampler_xxx_0, 0))
        self.connect((self.analog_pll_refout_cc_0, 0), (self.blocks_multiply_xx_0, 0))
        self.connect((self.analog_pll_refout_cc_0, 0), (self.blocks_multiply_xx_0, 1))
        self.connect((self.band_pass_filter_0, 0), (self.analog_pll_refout_cc_0, 0))
        self.connect((self.band_pass_filter_0_0, 0), (self.blocks_complex_to_real_0, 0))
        self.connect((self.blocks_add_xx_0, 0), (self.rational_resampler_xxx_0_0, 0))
        self.connect((self.blocks_complex_to_real_0, 0), (self.blocks_multiply_xx_1, 1))
        self.connect((self.blocks_delay_0, 0), (self.blocks_float_to_complex_0, 0))
        self.connect((self.blocks_float_to_complex_0, 0), (self.band_pass_filter_0, 0))
#        self.connect((self.blocks_multiply_const_vxx_0_0, 0), (self.audio_sink_1, 1))
        self.connect((self.blocks_multiply_const_vxx_0_0, 0), (self.blocks_wavfile_sink_0, 1))
#        self.connect((self.blocks_multiply_const_vxx_0_0_0, 0), (self.audio_sink_1, 0))
        self.connect((self.blocks_multiply_const_vxx_0_0_0, 0), (self.blocks_wavfile_sink_0, 0))
        self.connect((self.blocks_multiply_xx_0, 0), (self.band_pass_filter_0_0, 0))
        self.connect((self.blocks_multiply_xx_1, 0), (self.low_pass_filter_0_0_0, 0))
        self.connect((self.blocks_sub_xx_0, 0), (self.rational_resampler_xxx_0_0_0, 0))
        self.connect((self.low_pass_filter_0_0, 0), (self.analog_fm_demod_cf_0_0, 0))
        self.connect((self.low_pass_filter_0_0_0, 0), (self.blocks_add_xx_0, 1))
        self.connect((self.low_pass_filter_0_0_0, 0), (self.blocks_sub_xx_0, 1))
        self.connect((self.low_pass_filter_0_0_0_0, 0), (self.blocks_add_xx_0, 0))
        self.connect((self.low_pass_filter_0_0_0_0, 0), (self.blocks_sub_xx_0, 0))
        self.connect((self.rational_resampler_xxx_0, 0), (self.blocks_delay_0, 0))
        self.connect((self.rational_resampler_xxx_0, 0), (self.blocks_multiply_xx_1, 0))
        self.connect((self.rational_resampler_xxx_0, 0), (self.low_pass_filter_0_0_0_0, 0))
        self.connect((self.rational_resampler_xxx_0_0, 0), (self.analog_fm_deemph_0_0, 0))
        self.connect((self.rational_resampler_xxx_0_0_0, 0), (self.analog_fm_deemph_0, 0))
        self.connect((self.rtlsdr_source_0, 0), (self.low_pass_filter_0_0, 0))


    def get_resamp_rate(self):
        return self.resamp_rate

    def set_resamp_rate(self, resamp_rate):
        self.resamp_rate = resamp_rate
        self.set_pll_max_freq(19050*2*3.14159/self.resamp_rate)
        self.set_pll_min_freq(18950*2*3.14159/self.resamp_rate)
        self.band_pass_filter_0.set_taps(firdes.band_pass(1, self.resamp_rate, 17e3, 21e3, 1e3, firdes.WIN_HAMMING, 6.76))
        self.band_pass_filter_0_0.set_taps(firdes.band_pass(2, self.resamp_rate, 35e3, 41e3, 1e3, firdes.WIN_HAMMING, 6.76))
        self.low_pass_filter_0_0_0.set_taps(firdes.low_pass(self.Stereo_gain, self.resamp_rate, 15e3, 2.0e3, firdes.WIN_HAMMING, 6.76))
        self.low_pass_filter_0_0_0_0.set_taps(firdes.low_pass(1, self.resamp_rate, 15e3, 2.0e3, firdes.WIN_HAMMING, 6.76))

    def get_volume(self):
        return self.volume

    def set_volume(self, volume):
        self.volume = volume
        self.blocks_multiply_const_vxx_0_0.set_k(self.volume*0.01)
        self.blocks_multiply_const_vxx_0_0_0.set_k(self.volume*0.01)

    def get_tune_freq(self):
        return self.tune_freq

    def set_tune_freq(self, tune_freq):
        self.tune_freq = tune_freq
        self.rtlsdr_source_0.set_center_freq(self.tune_freq*1e6, 0)

    def get_samp_rate(self):
        return self.samp_rate

    def set_samp_rate(self, samp_rate):
        self.samp_rate = samp_rate
        self.low_pass_filter_0_0.set_taps(firdes.low_pass(1, self.samp_rate, 80e3, 10e3, firdes.WIN_HAMMING, 6.76))
        self.rtlsdr_source_0.set_sample_rate(self.samp_rate)

    def get_rf_gain(self):
        return self.rf_gain

    def set_rf_gain(self, rf_gain):
        self.rf_gain = rf_gain
        self.rtlsdr_source_0.set_gain(self.rf_gain, 0)

    def get_pll_min_freq(self):
        return self.pll_min_freq

    def set_pll_min_freq(self, pll_min_freq):
        self.pll_min_freq = pll_min_freq
        self.analog_pll_refout_cc_0.set_min_freq(self.pll_min_freq)

    def get_pll_max_freq(self):
        return self.pll_max_freq

    def set_pll_max_freq(self, pll_max_freq):
        self.pll_max_freq = pll_max_freq
        self.analog_pll_refout_cc_0.set_max_freq(self.pll_max_freq)

    def get_audio_stop(self):
        return self.audio_stop

    def set_audio_stop(self, audio_stop):
        self.audio_stop = audio_stop

    def get_audio_pass(self):
        return self.audio_pass

    def set_audio_pass(self, audio_pass):
        self.audio_pass = audio_pass

    def get_Stereo_gain(self):
        return self.Stereo_gain

    def set_Stereo_gain(self, Stereo_gain):
        self.Stereo_gain = Stereo_gain
        self.low_pass_filter_0_0_0.set_taps(firdes.low_pass(self.Stereo_gain, self.resamp_rate, 15e3, 2.0e3, firdes.WIN_HAMMING, 6.76))




def fm_mono_rec(top_block_cls=fmradio_mono_recoder, options=None):

    global exe_counter
    tb = top_block_cls()
    tb.start()

    start= time.time()
    print('Now Recording... Dulation Time = ' + str(dulation_time))

    while time.time() - start <= dulation_time:
        time.sleep(1)
        
    else:
        tb.stop()

    tb.wait()
    print("Finish to Recording.")
    exe_counter += 1

def fm_stereo_rec(top_block_cls=fmradio_stereo_recoder, options=None):

    global exe_counter
    tb = top_block_cls()
    tb.start()

    start= time.time()
    print('Now Recording... Dulation Time = ' + str(dulation_time))

    while time.time() - start <= dulation_time:
        time.sleep(1)
        
    else:
        tb.stop()

    tb.wait()
    print("Finish to Recording.")
    exe_counter += 1

#
#
if __name__ == '__main__':
    args = sys.argv
 
    if len(args) == 9:
        pass
    else:
        print('Option Error!')
        print('$ fmradio_recorder.exe <FREQ> <XX:YY> <week:No.> <Dulation:min> <times> <device arg.> <file_name> <Stereo>')
        quit()

TUNE_FREQ = float(sys.argv[1])
s_time = sys.argv[2]
set_weekday = int(sys.argv[3])
dulation_time = int(sys.argv[4]) * 60
loop_counter = int(sys.argv[5])
DEV_ARG = sys.argv[6]
FILE_NAME = sys.argv[7]
STEREO = sys.argv[8]
PATH = inifile.get('SECTION1', 'data4')

#TUNE_FREQ = 85.1
#s_time = "17:24"
#dulation_time = 5 * 60
exe_counter = 0
week_no = 'Monday'

now_weekday = datetime.date.today().weekday()
#print(set_weekday,now_weekday)

if STEREO == 'Stereo':
    print('ステレオで録音します')
    rec_main = fm_stereo_rec
else:
    print('モノラルで録音します')
    rec_main = fm_mono_rec

if set_weekday == 0:
    schedule.every().monday.at(s_time).do(rec_main)
    week_no = '月(録音回数=' + str(loop_counter) + ')'
elif set_weekday == 1:
    schedule.every().tuesday.at(s_time).do(rec_main)
    week_no = '火(録音回数=' + str(loop_counter) + ')'
elif set_weekday == 2:
    schedule.every().wednesday.at(s_time).do(rec_main)
    week_no = '水(録音回数=' + str(loop_counter) + ')'
elif set_weekday == 3:
    schedule.every().thursday.at(s_time).do(rec_main)
    week_no = '木(録音回数=' + str(loop_counter) + ')'
elif set_weekday == 4:
    schedule.every().friday.at(s_time).do(rec_main)
    week_no = '金(録音回数=' + str(loop_counter) + ')'
elif set_weekday == 5:
    schedule.every().saturday.at(s_time).do(rec_main)
    week_no = '土(録音回数=' + str(loop_counter) + ')'
elif set_weekday == 6:
    schedule.every().sunday.at(s_time).do(rec_main)
    week_no = '日(録音回数=' + str(loop_counter) + ')'
elif set_weekday == 7:
    schedule.every().monday.at(s_time).do(rec_main)
    schedule.every().tuesday.at(s_time).do(rec_main)
    schedule.every().wednesday.at(s_time).do(rec_main)
    schedule.every().thursday.at(s_time).do(rec_main)
    schedule.every().friday.at(s_time).do(rec_main)
    week_no = '平日(録音回数=' + str(loop_counter) + ')'
elif set_weekday == 9:
    schedule.every().day.at(s_time).do(rec_main)
    week_no = '日(録音回数=' + str(loop_counter) + ')'

print('予約スケジュール：'+ ' 曜日='+ str(week_no) + ' 開始時刻=' + s_time + ' 録音時間=' + str(dulation_time / 60) + '分')
#print('予約キャンセル：q + Enterを入力 誤入力時：Ctrl +Cで強制停止')
print('予約キャンセル：Ctrl +Cで強制停止')

#cond = True 

#def cancel():
#    global cond
#    time.sleep(1)
#    val = input()
#    if (val == "q"):
#        cond = False
        
#thread = Thread(target=cancel)
#thread.setDaemon(True)
#thread.start()

#while cond:
while True:
    schedule.run_pending()
#    print(exe_counter)
    if (exe_counter == loop_counter):
#        print('Break!')
        break
    time.sleep(1)

#print('予約録音がすべて終了しました。Enterを押すとプログラムを終了します。')
#thread.join()
