##################################################
#Project Name    : jfm_recorder (FM)
#File Name       : radiko_v3_analyzer
#Encoding        : python3.9(inclueding GRC3.8)
#Creation Date   : 2022.3.6
#Release note
#2022.3. 6 : 放送局をラジオボタン化、画面デザイン変更
#
#Copyright c 2021-2022 falconblog.org. All rights reserved.
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <https://www.gnu.org/licenses/>.
################################################## 

import lxml.etree
import sys
#import datetime
import requests
import configparser
inifile = configparser.ConfigParser()
inifile.read('settings_fm.ini',encoding='utf-8_sig')

def radiko_v3 (OPT):

#番組表URL設定
#   RADIKO_URL = "http://radiko.jp/v3/program/tomorrow/JP27.xml"
#    RADIKO_URL = "http://radiko.jp/v3/program/today/JP27.xml"
#    RADIKO_URL = "http://radiko.jp/v3/program/now/JP27.xml"
#   RADIKO_URL = 'E:\GRC21\JP27.xml'
    RADIKO_URL = inifile.get('SECTION1', 'data5')
#   area_id: JP13(Tokyo) ,JP27(Osaka)

#URLアクセスチェック
    try:
        response = requests.get(RADIKO_URL)
        response.raise_for_status()
    except requests.exceptions.RequestException as e:
        output = '番組表受信エラー'
#        print("番組表受信エラー")
        return output
    else:
        pass

#URL解析
    root = lxml.etree.parse(RADIKO_URL)
#    print(OPT)
    progl = root.xpath('.//station[@id="' + str(OPT) +'"]')

#else:
#    progl = root.xpath(".//progs")
#print(list(progl))
    output = '番組情報を取得できません'
    for progs in progl:
#    name = progs.getparent().xpath('.//name')[0].text
        name = progs.xpath('.//name')[0].text
        date = progs.xpath(".//date")[0].text # YYYYMMDD
#        print ("/".join([date[0:4], date[4:6], date[6:8]]) + "  " + str(name)
        output = ("/".join([date[0:4], date[4:6], date[6:8]]) + "  " + str(name))
        for prog in progs.xpath(".//prog"):
            title = prog.xpath(".//title")[0].text
            pfm = prog.xpath(".//pfm")[0].text
            stime = prog.get("ftl")  # HHMM
            etime = prog.get("tol")  # HHMM
#           print(str(stime) + ' ' +  str(etime) + str(title))
            output += ("\n  " + stime[0:2] + ":"+stime[2:4] + " - " + etime[0:2] + ":" + etime[2:4]\
                + "  " + str(title) + '\n （出演）' + str(pfm))
    return output

# main関数
#if __name__ == '__main__':
#    args = sys.argv
#    if len(args) == 2:
#        pass
#    else:
#        print('Option Error!')
#        quit()
#    out = sys.argv[1]
#    print(radiko_v3(str(out)))
    