##################################################
#Project Name    : j-radio_recorder (AM)
#File Name       : jam_rec_(version No.), jam_recorder_(version No.)
#Encoding        : python3.9(inclueding GRC3.8)
#Creation Date   : 2022.1.16
#Release note:
#2022.2.24 : jamradio_recorder04のver_upに伴う呼び出しファイルの変更
#
#Copyright c 2021-2022 falconblog.org. All rights reserved.
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <https://www.gnu.org/licenses/>.
##################################################
import sys
from PyQt5.QtWidgets import (QWidget,
    QVBoxLayout, QHBoxLayout, QApplication, QPushButton, QLabel, QLineEdit, QComboBox)
from PyQt5 import*
import subprocess
#import json
import configparser

# 初期設定値ファイルセット
inifile = configparser.ConfigParser()
inifile.read('settings_am.ini',encoding='utf-8_sig')

class Example(QWidget):

    def __init__(self):
        super().__init__()

        self.initUI()


    def initUI(self):
        font=QtGui.QFont("00コミック7",16)

# ラベル名の設定
        lbl1 = QLabel('AM周波数(yyyy KHz) ')
        lbl1.setFont(font)
#        lbl1a = QLabel(' FM周波数(xx.x MHz)')
#        lbl1a.setFont(font)        
        
        lbl2 = QLabel('開始時刻(XX:YY)')
        lbl2.setFont(font)
        lbl3 = QLabel('録音回数(1-9:録音回数)')
        lbl3.setFont(font)
        lbl4 = QLabel('録音時間(min)')
        lbl4.setFont(font)
        lbl5 = QLabel('USBチューナー選択')
        lbl5.setFont(font)
        lbl6 = QLabel('予約する')
        lbl6.setFont(font)
        self.lbl7 = QLabel('試聴してから予約してください')
        self.lbl7.setFont(font)

# 受信周波数設定
#        self.edit1=QLineEdit('828',self)
        self.edit1=QLineEdit(inifile.get('SECTION1', 'data1'),self)
        self.edit1.setFont(font)
#        self.edit1a=QLineEdit('85.1',self)
#        self.edit1a.setFont(font)

# 開始時間設定    
        self.edit2=QLineEdit(inifile.get('SECTION1', 'data2'),self)
        self.edit2.setFont(font)
#        self.edit3=QLineEdit('6',self)
#        self.edit3.setFont(font)

# 録音回数設定
        global lbl31
        lbl31 = '5'
#        self.lbl31 = QLabel('5',self)
        self.combo3 = QComboBox(self)
#        self.combo3.addItem('0')
        self.combo3.addItem('1')
        self.combo3.addItem('2')
        self.combo3.addItem('3')
        self.combo3.addItem('4')
        self.combo3.addItem('5')
        self.combo3.addItem('6')
        self.combo3.addItem('7')
        self.combo3.addItem('8')
        self.combo3.addItem('9')
        self.combo3.setCurrentIndex(4)
        self.combo3.setFont(font)

# 録音時間設定              
        self.edit4=QLineEdit(inifile.get('SECTION1', 'data3'),self)
        self.edit4.setFont(font)

# USBチューナー設定
        global lbl51
        lbl51 = 'rtl=0,direct_samp=2'
#        self.edit5=QLineEdit('rtl=0,direct_samp=2',self)
#        self.edit5.setFont(font)
#        self.lbl51 = QLabel('rtl=0,direct_samp=2',self)
        self.combo5 = QComboBox(self)
        self.combo5.addItem('rtl=0,direct_samp=2')
        self.combo5.addItem('hackrf=0')
        self.combo5.addItem('rtl=1,direct_samp=2')
        self.combo5.addItem('rtl=0')
        self.combo5.setFont(font)

# 放送受信ボタン設定1
        btn4=QPushButton("AM放送を聴く")
        btn4.setCheckable(False)
        btn4.setFont(font)
        btn4.setStyleSheet("background-color: #ffcf54")

# 放送受信ボタン設定2
#        btn5=QPushButton("FM放送を聴く")
#        btn5.setCheckable(False)
#        btn5.setFont(font)
#        btn5.setStyleSheet("background-color: #ffcf54")

# 放送予約ボタン設定1        
        btn6=QPushButton("AM放送を予約")
        btn6.setCheckable(True)
        btn6.setFont(font)
        btn6.setStyleSheet("background-color: #ffcf54")

# 放送予約ボタン設定2
#        btn7=QPushButton("FM放送を予約")
#        btn7.setCheckable(True)
#        btn7.setFont(font)
#        btn7.setStyleSheet("background-color: #ffcf54")

# レイアウト設定        
        firstlayout=QHBoxLayout()
        firstlayout.addWidget(lbl1)
#        firstlayout.addWidget(lbl1a)
#        firstlayout.addWidget(self.edit1)

        firstlayout_a=QHBoxLayout()
#        firstlayout_a.addWidget(lbl1)
#       firstlayout_a.addWidget(lbl1a)
        firstlayout_a.addWidget(self.edit1)
#        firstlayout_a.addWidget(self.edit1a)

        secondlayout=QVBoxLayout()
        secondlayout.addWidget(lbl2)
        secondlayout.addWidget(self.edit2)
#        secondlayout.addWidget(btn2)

        thirdlayout=QVBoxLayout()
        thirdlayout.addWidget(lbl3)
#        thirdlayout.addWidget(self.edit3)
        thirdlayout.addWidget(self.combo3)
#        thirdlayout.addWidget(btn3)

        fourlayout=QVBoxLayout()
        fourlayout.addWidget(lbl4)
        fourlayout.addWidget(self.edit4)
#        fourlayout.addWidget(btn3)

        fivelayout=QVBoxLayout()
        fivelayout.addWidget(lbl5)
        fivelayout.addWidget(self.combo5)
#        fivelayout.addWidget(btn4)

        sixlayout_a=QHBoxLayout()
#        sixlayout.addWidget(lbl5)
#        sixlayout.addWidget(self.edit5)
        sixlayout_a.addWidget(btn4)
#        sixlayout_a.addWidget(btn5) 

        sixlayout_b=QHBoxLayout()
#        sixlayout.addWidget(lbl5)
#        sixlayout.addWidget(self.edit5)
        sixlayout_b.addWidget(btn6)
#        sixlayout_b.addWidget(btn7) 

        sevenlayout=QVBoxLayout()
        sevenlayout.addWidget(self.lbl7)
#        sevenlayout.addWidget(self.edit5)
#        sevenlayout.addWidget(btn5)

# レイアウト構築        
        layout=QVBoxLayout()
        layout.addLayout(firstlayout)
        layout.addLayout(firstlayout_a)
        layout.addLayout(secondlayout)
        layout.addLayout(thirdlayout)
        layout.addLayout(fourlayout)
        layout.addLayout(fivelayout)
        layout.addLayout(sixlayout_a)
        layout.addLayout(sixlayout_b)
        layout.addLayout(sevenlayout)
        
        self.setLayout(layout)

# ボタンクリック挙動設定
        btn4.clicked[bool].connect(self.buttonClicked_ra)
#        btn5.clicked[bool].connect(self.buttonClicked_rf)
        btn6.clicked[bool].connect(self.buttonClicked_ya)  
#        btn7.clicked[bool].connect(self.buttonClicked_yf)
        self.combo3.activated[str].connect(self.onActivated3)
        self.combo5.activated[str].connect(self.onActivated5)

# タイトル、ウィンドウ位置設定        
        self.setWindowTitle('AM Radio Recorder v.0.4 (C)falcon')
        self.setGeometry(400, 100, 450, 400)

#録音回数プルダウン設定
    def onActivated3(self, text):

        global lbl31
#        self.lbl31.setText(text)
#        self.lbl31.adjustSize()
        lbl31 = str(text)
#        print(lbl31)

#USBチューナープルダウン設定
    def onActivated5(self, text):

        global lbl51
#        self.lbl51.setText(text)
#        self.lbl51.adjustSize()
        lbl51 = str(text)
#        print(lbl51)

# AM予約録音サブプロセス起動   
    def buttonClicked_ya(self,pressed):

#        if pressed:
            opt1 = str(self.edit1.text())
            opt2 = str(self.edit2.text())
            opt3 = str(lbl31)
            opt4 = str(self.edit4.text())
            opt5 = str(lbl51)
            print(opt1,opt2,opt3,opt4,opt5)
            cmd = 'jamradio_recorder_04 {} {} {} {} {}'.format(opt1,opt2,opt3,opt4,opt5)
#            print(cmd)
            subprocess.Popen(cmd,shell=True).wait()
            self.close()

# AM試聴サブプロセス起動
    def buttonClicked_ra(self,pressed):

#        if pressed:
#            self.lbl7.setText('ラジオ視聴中')
            opt1 = str(self.edit1.text())
#            opt2 = str(self.edit2.text())
#            opt3 = str(self.edit3.text())
#            opt4 = str(self.edit4.text())
            opt5 = str(lbl51)
#            print(opt1,opt2,opt3,opt4,opt5)
            cmd = 'amradio_tuner_01.exe {} {}'.format(opt1, opt5)
#            print(cmd)
            subprocess.Popen(cmd,shell=True).wait()
#            self.close()

# FM視聴サブプロセス起動
    def buttonClicked_yf(self,pressed):

#        if pressed:
            self.lbl7.setText('録音予約中')
            opt1 = str(self.edit1a.text())
            opt2 = str(self.edit2.text())
#            opt3 = str(self.edit3.text())
            opt3 = str(self.lbl31.text())
            opt4 = str(self.edit4.text())
            opt5 = str(self.lbl51.text())
            print(opt1,opt2,opt3,opt4,opt5)
            cmd = 'jfmradio_recorder_03 {} {} {} {} {}'.format(opt1,opt2,opt3,opt4,opt5)
#            print(cmd)
            subprocess.Popen(cmd,shell=True).wait()
            self.close()

# FM視聴サブプロセス起動
    def buttonClicked_rf(self,pressed):

#        if pressed:
            self.setWindowTitle('FMラジオ放送受信中')
#            self.lbl7.setText('ラジオ視聴中')
            opt1 = str(self.edit1a.text())
#            opt2 = str(self.edit2.text())
#            opt3 = str(self.edit3.text())
#            opt4 = str(self.edit4.text())
            opt5 = str(self.lbl51.text())
#            print(opt1,opt2,opt3,opt4,opt5)
            cmd = 'fmradio_tuner_01.exe {} {}'.format(opt1, opt5)
#            print(cmd)
            subprocess.Popen(cmd,shell=True).wait()

if __name__ == '__main__':

    app = QApplication(sys.argv)
    main_window = Example()
    main_window.show()
    sys.exit(app.exec_())