##################################################
#Project Name    : gogaku_recorder (AM)
#File Name       : gogaku_rec_(version No.), gogaku_recorder_(version No.)
#Encoding        : python3.9(inclueding GRC3.8)
#Creation Date   : 2022.3.6
#Release note:
#
#
#Copyright c 2021-2022 falconblog.org. All rights reserved.
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <https://www.gnu.org/licenses/>.
##################################################
import sys
from PyQt5.QtWidgets import (QWidget,
    QVBoxLayout, QHBoxLayout, QApplication, QPushButton, QLabel, QLineEdit, QComboBox, QTextEdit)
from PyQt5 import*
import subprocess
import configparser

# 初期設定値ファイルセット
inifile = configparser.ConfigParser()
inifile.read('settings_gogaku.ini',encoding='utf-8_sig')

class Example(QWidget):

    def __init__(self):
        super().__init__()

        self.initUI()


    def initUI(self):
        font=QtGui.QFont("00コミック7",16)
        font2=QtGui.QFont("00コミック7",10)

# ラベル名の設定
        global lbl7
        lbl1 = QLabel('NHKラジオ第２周波数(KHz) ')
        lbl1.setFont(font)        
        lbl2 = QLabel('録音番組選択')
        lbl2.setFont(font)
        lbl3 = QLabel('録音回数')
        lbl3.setFont(font)
#        lbl4 = QLabel('録音時間(min)')
#        lbl4.setFont(font)
        lbl5 = QLabel('USBチューナー選択')
        lbl5.setFont(font)
        lbl6 = QLabel('予約する')
        lbl6.setFont(font)
#        lbl7 = QLabel(inifile.get('CH1', 'week_comment'))
        lbl7 = QTextEdit(inifile.get('CH1', 'week_comment'))
        lbl7.setFont(font2)

# 受信周波数設定
#        self.edit1=QLineEdit('828',self)
        self.edit1=QLineEdit(inifile.get('SECTION1', 'data1'),self)
        self.edit1.setFont(font)

# 開始時間設定    
#        self.edit2=QLineEdit(inifile.get('SECTION1', 'data2'),self)
#        self.edit2.setFont(font)
#        self.edit3=QLineEdit('6',self)
#        self.edit3.setFont(font)

# 録音回数設定
        global lbl31
        lbl31 = '5'
#        self.lbl31 = QLabel('5',self)
        self.combo3 = QComboBox(self)
#        self.combo3.addItem('0')
        self.combo3.addItem('1')
        self.combo3.addItem('2')
        self.combo3.addItem('3')
        self.combo3.addItem('4')
        self.combo3.addItem('5')
        self.combo3.addItem('6')
        self.combo3.addItem('8')
        self.combo3.addItem('10')
        self.combo3.addItem('25')
        self.combo3.setCurrentIndex(4)
        self.combo3.setFont(font)

# 録音時間設定              
#        self.edit4=QLineEdit(inifile.get('SECTION1', 'data3'),self)
#        self.edit4.setFont(font)

# USBチューナー設定
        global lbl51
        lbl51 = 'rtl=0,direct_samp=2'
#        self.edit5=QLineEdit('rtl=0,direct_samp=2',self)
#        self.edit5.setFont(font)
#        self.lbl51 = QLabel('rtl=0,direct_samp=2',self)
        self.combo5 = QComboBox(self)
        self.combo5.addItem('rtl=0,direct_samp=2')
        self.combo5.addItem('hackrf=0')
        self.combo5.addItem('rtl=1,direct_samp=2')
        self.combo5.addItem('rtl=0')
        self.combo5.setFont(font)

# ラジオボタングループ
        self.radioGroup = QtWidgets.QButtonGroup()

# 番組ボタン選択
        btn11=QtWidgets.QRadioButton(inifile.get('CH1', 'channel'),self)
        btn11.setChecked(True)
        btn11.setFont(font)
        btn11.setStyleSheet(inifile.get('CH1', 'back_color'))

        btn12=QtWidgets.QRadioButton(inifile.get('CH2', 'channel'),self)
        btn12.setChecked(False)
        btn12.setFont(font)
        btn12.setStyleSheet(inifile.get('CH2', 'back_color'))

        btn13=QtWidgets.QRadioButton(inifile.get('CH3', 'channel'),self)
        btn13.setChecked(False)
        btn13.setFont(font)
        btn13.setStyleSheet(inifile.get('CH3', 'back_color'))

        btn14=QtWidgets.QRadioButton(inifile.get('CH4', 'channel'),self)
        btn14.setChecked(False)
        btn14.setFont(font)
        btn14.setStyleSheet(inifile.get('CH4', 'back_color'))

        btn15=QtWidgets.QRadioButton(inifile.get('CH5', 'channel'),self)
        btn15.setChecked(False)
        btn15.setFont(font)
        btn15.setStyleSheet(inifile.get('CH5', 'back_color'))

        btn16=QtWidgets.QRadioButton(inifile.get('CH6', 'channel'),self)
        btn16.setChecked(False)
        btn16.setFont(font)
        btn16.setStyleSheet(inifile.get('CH6', 'back_color'))

        btn17=QtWidgets.QRadioButton(inifile.get('CH7', 'channel'),self)
        btn17.setChecked(False)
        btn17.setFont(font)
        btn17.setStyleSheet(inifile.get('CH7', 'back_color'))

        btn18=QtWidgets.QRadioButton(inifile.get('CH8', 'channel'),self)
        btn18.setChecked(False)
        btn18.setFont(font)
        btn18.setStyleSheet(inifile.get('CH8', 'back_color'))

        btn19=QtWidgets.QRadioButton(inifile.get('CH9', 'channel'),self)
        btn19.setChecked(False)
        btn19.setFont(font)
        btn19.setStyleSheet(inifile.get('CH9', 'back_color'))

        btn20=QtWidgets.QRadioButton(inifile.get('CH10', 'channel'),self)
        btn20.setChecked(False)
        btn20.setFont(font)
        btn20.setStyleSheet(inifile.get('CH10', 'back_color'))

# ラジオボタンオブジェクトのグループ登録
        self.radioGroup.addButton(btn11, 1)
        self.radioGroup.addButton(btn12, 2)
        self.radioGroup.addButton(btn13, 3)
        self.radioGroup.addButton(btn14, 4)
        self.radioGroup.addButton(btn15, 5)
        self.radioGroup.addButton(btn16, 6)
        self.radioGroup.addButton(btn17, 7)
        self.radioGroup.addButton(btn18, 8)
        self.radioGroup.addButton(btn19, 9)
        self.radioGroup.addButton(btn20, 10)
# ラジオボタン初期値設定
        global lbl21,lbl41,lbl61,lbl71
        #btn11.setChecked(True)
        lbl21 = str(inifile.get('CH1', 'stime'))
        lbl41 = str(inifile.get('CH1', 'dulation'))
        lbl61 = str(inifile.get('CH1', 'file_name'))
        lbl71 = str(inifile.get('CH1', 'week_table'))
# 放送受信ボタン設定1
        btn4=QPushButton("AM放送を聴く")
        btn4.setCheckable(False)
        btn4.setFont(font)
        btn4.setStyleSheet("background-color: #ffcf54")

# 放送予約ボタン設定1        
        btn6=QPushButton("AM放送を予約")
        btn6.setCheckable(True)
        btn6.setFont(font)
#        btn6.setStyleSheet("background-color: #ffcf54")
        btn6.setStyleSheet("background-color: #ff6d86")

# レイアウト設定        
        firstlayout=QHBoxLayout()
        firstlayout.addWidget(lbl1)
#        firstlayout.addWidget(lbl1a)
#        firstlayout.addWidget(self.edit1)

        firstlayout_a=QHBoxLayout()
#        firstlayout_a.addWidget(lbl1)
#       firstlayout_a.addWidget(lbl1a)
        firstlayout_a.addWidget(self.edit1)
#        firstlayout_a.addWidget(self.edit1a)

        secondlayout=QVBoxLayout()
        secondlayout.addWidget(lbl2)
        secondlayout.addWidget(btn11)
        secondlayout.addWidget(btn12)
        secondlayout.addWidget(btn13)
        secondlayout.addWidget(btn14)
        secondlayout.addWidget(btn15)
        secondlayout.addWidget(btn16)
        secondlayout.addWidget(btn17)
        secondlayout.addWidget(btn18)
        secondlayout.addWidget(btn19)
        secondlayout.addWidget(btn20)
        
        thirdlayout=QVBoxLayout()
        thirdlayout.addWidget(lbl3)
#        thirdlayout.addWidget(self.edit3)
        thirdlayout.addWidget(self.combo3)
#        thirdlayout.addWidget(btn3)

#        fourlayout=QVBoxLayout()
#        fourlayout.addWidget(lbl4)
#        fourlayout.addWidget(self.edit4)
#        fourlayout.addWidget(btn3)

        fivelayout=QVBoxLayout()
        fivelayout.addWidget(lbl5)
        fivelayout.addWidget(self.combo5)
#        fivelayout.addWidget(btn4)

        sixlayout_a=QHBoxLayout()
#        sixlayout.addWidget(lbl5)
#        sixlayout.addWidget(self.edit5)
        sixlayout_a.addWidget(btn4)
#        sixlayout_a.addWidget(btn5) 

        sixlayout_b=QHBoxLayout()
#        sixlayout.addWidget(lbl5)
#        sixlayout.addWidget(self.edit5)
        sixlayout_b.addWidget(btn6)
#        sixlayout_b.addWidget(btn7) 

        sevenlayout=QVBoxLayout()
        sevenlayout.addWidget(lbl7)
#        sevenlayout.addWidget(self.edit5)
#        sevenlayout.addWidget(btn5)

# レイアウト構築        
        layout=QVBoxLayout()
        layout.addLayout(firstlayout)
        layout.addLayout(firstlayout_a)
        layout.addLayout(secondlayout)
        layout.addLayout(thirdlayout)
#        layout.addLayout(fourlayout)
        layout.addLayout(fivelayout)
        layout.addLayout(sixlayout_a)
#        layout.addLayout(sixlayout_b)
        layout.addLayout(sevenlayout)
        layout.addLayout(sixlayout_b)
        
        self.setLayout(layout)

# ボタンクリック挙動設定
        btn11.clicked[bool].connect(self.buttonClicked_1)
        btn12.clicked[bool].connect(self.buttonClicked_2)
        btn13.clicked[bool].connect(self.buttonClicked_3)
        btn14.clicked[bool].connect(self.buttonClicked_4)
        btn15.clicked[bool].connect(self.buttonClicked_5)
        btn16.clicked[bool].connect(self.buttonClicked_6)
        btn17.clicked[bool].connect(self.buttonClicked_7)
        btn18.clicked[bool].connect(self.buttonClicked_8)
        btn19.clicked[bool].connect(self.buttonClicked_9)
        btn20.clicked[bool].connect(self.buttonClicked_10)
#
        btn4.clicked[bool].connect(self.buttonClicked_ra)
        btn6.clicked[bool].connect(self.buttonClicked_ya)  
        self.combo3.activated[str].connect(self.onActivated3)
        self.combo5.activated[str].connect(self.onActivated5)

# タイトル、ウィンドウ位置設定        
        self.setWindowTitle('語学Recorder v.0.1 (C)falcon')
        self.setGeometry(400, 100, 450, 400)

# 番組変数設定
    def buttonClicked_1(self,pressed):
        global lbl21,lbl41,lbl61,lbl71
        lbl21 = str(inifile.get('CH1', 'stime'))
        lbl41 = str(inifile.get('CH1', 'dulation'))
        lbl61 = str(inifile.get('CH1', 'file_name'))
        lbl71 = str(inifile.get('CH1', 'week_table'))
        lbl7.clear()
        lbl7.append(inifile.get('CH1', 'week_comment'))
    def buttonClicked_2(self,pressed):
        global lbl21,lbl41,lbl61,lbl71
        lbl21 = str(inifile.get('CH2', 'stime'))
        lbl41 = str(inifile.get('CH2', 'dulation'))
        lbl61 = str(inifile.get('CH2', 'file_name'))
        lbl71 = str(inifile.get('CH2', 'week_table'))    
        lbl7.clear()
        lbl7.append(inifile.get('CH2', 'week_comment'))
    def buttonClicked_3(self,pressed):
        global lbl21,lbl41,lbl61,lbl71
        lbl21 = str(inifile.get('CH3', 'stime'))
        lbl41 = str(inifile.get('CH3', 'dulation'))
        lbl61 = str(inifile.get('CH3', 'file_name'))
        lbl71 = str(inifile.get('CH3', 'week_table'))
        lbl7.clear()
        lbl7.append(inifile.get('CH3', 'week_comment'))
    def buttonClicked_4(self,pressed):
        global lbl21,lbl41,lbl61,lbl71
        lbl21 = str(inifile.get('CH4', 'stime'))
        lbl41 = str(inifile.get('CH4', 'dulation'))
        lbl61 = str(inifile.get('CH4', 'file_name'))
        lbl71 = str(inifile.get('CH4', 'week_table'))
        lbl7.clear()
        lbl7.append(inifile.get('CH4', 'week_comment'))
    def buttonClicked_5(self,pressed):
        global lbl21,lbl41,lbl61,lbl71
        lbl21 = str(inifile.get('CH5', 'stime'))
        lbl41 = str(inifile.get('CH5', 'dulation'))
        lbl61 = str(inifile.get('CH5', 'file_name'))
        lbl71 = str(inifile.get('CH5', 'week_table'))
        lbl7.clear()
        lbl7.append(inifile.get('CH5', 'week_comment'))
    def buttonClicked_6(self,pressed):
        global lbl21,lbl41,lbl61,lbl71
        lbl21 = str(inifile.get('CH6', 'stime'))
        lbl41 = str(inifile.get('CH6', 'dulation'))
        lbl61 = str(inifile.get('CH6', 'file_name'))
        lbl71 = str(inifile.get('CH6', 'week_table'))
        lbl7.clear()
        lbl7.append(inifile.get('CH6', 'week_comment'))
    def buttonClicked_7(self,pressed):
        global lbl21,lbl41,lbl61,lbl71
        lbl21 = str(inifile.get('CH7', 'stime'))
        lbl41 = str(inifile.get('CH7', 'dulation'))
        lbl61 = str(inifile.get('CH7', 'file_name'))
        lbl71 = str(inifile.get('CH7', 'week_table'))
        lbl7.clear()
        lbl7.append(inifile.get('CH7', 'week_comment'))
    def buttonClicked_8(self,pressed):
        global lbl21,lbl41,lbl61,lbl71
        lbl21 = str(inifile.get('CH8', 'stime'))
        lbl41 = str(inifile.get('CH8', 'dulation'))
        lbl61 = str(inifile.get('CH8', 'file_name'))
        lbl71 = str(inifile.get('CH8', 'week_table'))
        lbl7.clear()
        lbl7.append(inifile.get('CH8', 'week_comment'))
    def buttonClicked_9(self,pressed):
        global lbl21,lbl41,lbl61,lbl71
        lbl21 = str(inifile.get('CH9', 'stime'))
        lbl41 = str(inifile.get('CH9', 'dulation'))
        lbl61 = str(inifile.get('CH9', 'file_name'))
        lbl71 = str(inifile.get('CH9', 'week_table'))
        lbl7.clear()
        lbl7.append(inifile.get('CH9', 'week_comment'))
    def buttonClicked_10(self,pressed):
        global lbl21,lbl41,lbl61,lbl71,lbl7
        lbl21 = str(inifile.get('CH10', 'stime'))
        lbl41 = str(inifile.get('CH10', 'dulation'))
        lbl61 = str(inifile.get('CH10', 'file_name'))
        lbl71 = str(inifile.get('CH10', 'week_table'))
        lbl7.clear()
        lbl7.append(inifile.get('CH10', 'week_comment'))
#        print(lbl21)
#        print(lbl41)
#        print(lbl61)
#        print(lbl71)
        
#録音回数プルダウン設定
    def onActivated3(self, text):
        global lbl31
#        self.lbl31.setText(text)
#        self.lbl31.adjustSize()
        lbl31 = str(text)
#        print(lbl31)

#USBチューナープルダウン設定
    def onActivated5(self, text):
        global lbl51
#        self.lbl51.setText(text)
#        self.lbl51.adjustSize()
        lbl51 = str(text)
#        print(lbl51)

# AM予約録音サブプロセス起動   
    def buttonClicked_ya(self,pressed):
#        if pressed:
            opt1 = str(self.edit1.text())
            opt2 = str(lbl21)
            opt3 = str(lbl31)
            opt4 = str(lbl41)
            opt5 = str(lbl51)
            opt6 = str(lbl61)
            opt7 = str(lbl71)
            print(opt1,opt2,opt3,opt4,opt5,opt6,opt7)
            cmd = 'gogaku_recorder_01.exe {} {} {} {} {} {} {}'.format(opt1,opt2,opt3,opt4,opt5,opt6,opt7)
#            print(cmd)
            subprocess.Popen(cmd,shell=True).wait()
            self.close()

# AM試聴サブプロセス起動
    def buttonClicked_ra(self,pressed):
#        if pressed:
#            self.lbl7.setText('ラジオ視聴中')
            opt1 = str(self.edit1.text())
#            opt2 = str(self.edit2.text())
#            opt3 = str(self.edit3.text())
#            opt4 = str(self.edit4.text())
            opt5 = str(lbl51)
#            print(opt1,opt2,opt3,opt4,opt5)
            cmd = 'amradio_tuner_01.exe {} {}'.format(opt1, opt5)
#            print(cmd)
            subprocess.Popen(cmd,shell=True).wait()
#            self.close()

if __name__ == '__main__':

    app = QApplication(sys.argv)
    main_window = Example()
    main_window.show()
    sys.exit(app.exec_())